/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.HostPortEvent;
import apiipc.generated.events.HostPortEventListener;
import apiipc.generated.sim.HostPort;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPortEventRegistry
extends IPCEventRegistry {
    protected Set<HostPortEventListener> globalListeners = new HashSet<HostPortEventListener>();
    protected Map<String, Set<HostPortEventListener>> specificObjectListeners = new HashMap<String, Set<HostPortEventListener>>();

    public HostPortEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "HostPort";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        HostPortEvent hostPortEvent = null;
        if (string.equalsIgnoreCase("ipChanged")) {
            hostPortEvent = new HostPortEvent.IpChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("ipv6LinkLocalChanged")) {
            hostPortEvent = new HostPortEvent.Ipv6LinkLocalChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("ipv6AddressAdded")) {
            hostPortEvent = new HostPortEvent.Ipv6AddressAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("ipv6AddressRemoved")) {
            hostPortEvent = new HostPortEvent.Ipv6AddressRemoved(iPCEventLTV);
        } else {
            return;
        }
        for (HostPortEventListener object : this.globalListeners) {
            object.handleEvent(hostPortEvent);
        }
        Set<HostPortEventListener> set = this.specificObjectListeners.get(hostPortEvent.objectUUID.toString());
        if (set != null) {
            for (HostPortEventListener hostPortEventListener : set) {
                hostPortEventListener.handleEvent(hostPortEvent);
            }
        }
    }

    public void addListenerFiltered(HostPortEventListener hostPortEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("ipChanged");
                this.register("ipv6LinkLocalChanged");
                this.register("ipv6AddressAdded");
                this.register("ipv6AddressRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(hostPortEventListener);
    }

    public void addSpecificListenerFiltered(HostPortEventListener hostPortEventListener, HostPort hostPort, List<String> list) throws IOException {
        UUID uUID = hostPort.getObjectUUID();
        String string = uUID.toString();
        Set<HostPortEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<HostPortEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "ipChanged");
                this.register(uUID, "ipv6LinkLocalChanged");
                this.register(uUID, "ipv6AddressAdded");
                this.register(uUID, "ipv6AddressRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(hostPortEventListener);
    }

    public void removeListenerFiltered(HostPortEventListener hostPortEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("ipChanged");
                this.deregister("ipv6LinkLocalChanged");
                this.deregister("ipv6AddressAdded");
                this.deregister("ipv6AddressRemoved");
            }
            this.globalListeners.remove(hostPortEventListener);
        }
    }

    public void removeSpecificListenerFiltered(HostPortEventListener hostPortEventListener, HostPort hostPort, List<String> list) throws IOException {
        UUID uUID = hostPort.getObjectUUID();
        String string = uUID.toString();
        Set<HostPortEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "ipChanged");
            this.deregister(uUID, "ipv6LinkLocalChanged");
            this.deregister(uUID, "ipv6AddressAdded");
            this.deregister(uUID, "ipv6AddressRemoved");
            set.remove(hostPortEventListener);
        }
    }

    public void addListener(HostPortEventListener hostPortEventListener) throws IOException {
        this.addListenerFiltered(hostPortEventListener, null);
    }

    public void addListener(HostPortEventListener hostPortEventListener, HostPort hostPort) throws IOException {
        this.addSpecificListenerFiltered(hostPortEventListener, hostPort, null);
    }

    public void removeListener(HostPortEventListener hostPortEventListener) throws IOException {
        this.removeListenerFiltered(hostPortEventListener, null);
    }

    public void removeListener(HostPortEventListener hostPortEventListener, HostPort hostPort) throws IOException {
        this.removeSpecificListenerFiltered(hostPortEventListener, hostPort, null);
    }
}

